﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/Ei8htPOS.Master" AutoEventWireup="true" CodeBehind="SendNewsletters.aspx.cs" Inherits="AZVIC.Ei8htPOS.WebUI.Admin.Newsletter.SendNewsletters" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="pageheader">
        <h2>
            <i class="fa fa-paper-plane-o"></i> Send Newsletters
        </h2>
        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>You are here</li>
                <li><a href="../Dashboard.aspx">Ei8ht POS</a></li>
                <li><a href="Newsletters.aspx">Newsletter</a></li>
                <li class="active">Send Newsletter</li>
            </ol>
        </div>
    </div>
    <div class="main searchFields">
        <div class="row">
            <asp:Label ID="lblMessage" runat="server" CssClass="labelerror" />
        </div>
        <div class="row">
            <h4>Select Customers to Send News Letter</h4>
        </div><br /><br />
        <div class="row">
            <asp:RadioButton ID="radioAll" runat="server" Text=" Send to all subscribed customers" GroupName="cust" CssClass="cwhite" rel="all" />
            <br />
            <asp:RadioButton ID="radioSelected" runat="server" Text=" Selected customers" GroupName="cust" CssClass="cwhite" rel="selected" />
        </div><br /><br />
        <div class="row">
            <asp:Button ID="btnProceed" runat="server" CssClass="btn btn-primary btn-lg" Text="Proceed"
                OnClientClick="return checkSelectedCustomer('Please select customer to send news letter.');" OnClick="btnProceed_Click" />
            &nbsp;
                    <asp:Button ID="btnCancel" runat="server" CssClass="btn btn-primary btn-lg loading" Text="Cancel" OnClick="btnCancel_Click" />
        </div>
        
    </div>
<section class="tile contentField color customers">
        <div class="tile-header">
            <h1>Newsletters</h1>
        </div>
        <div class="tile-body nopadding">

            <div class="responsive-table">
                 <asp:GridView runat="server" ID="grdCustomers" CssClass="table"
                            Width="98%" GridLines="Both" AutoGenerateColumns="false">
                            <Columns>
                                <asp:TemplateField ItemStyle-HorizontalAlign="Center" HeaderStyle-HorizontalAlign="Center">
                                    <HeaderTemplate>
                                        <asp:CheckBox ID="chkSelectAll" runat="server" CssClass="chkHeader" />
                                    </HeaderTemplate>
                                    <ItemTemplate>
                                        <asp:CheckBox ID="chkSelect" runat="server" CssClass="chkItem" />
                                        <asp:HiddenField runat="server" ID="hdUserAccountID" Value='<%# Eval("UniqueID") %>' />
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:BoundField HeaderText="User Name" DataField="UserName" />
                                <asp:BoundField HeaderText="Salutation" DataField="Salutation" />
                                <asp:BoundField HeaderText="First Name" DataField="FirstName" />
                                <asp:BoundField HeaderText="Last Name" DataField="LastName" />
                                <asp:BoundField HeaderText="Email" DataField="Email" />
                                <asp:TemplateField HeaderText="Subscribed">
                                    <ItemTemplate>
                                        <%#bool.Parse(DataBinder.Eval(Container.DataItem, "IsSubscribed").ToString()) ? "Yes" : "No"%>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                            <PagerSettings Mode="NumericFirstLast" Visible="true" NextPageText="" PreviousPageText=""
                                Position="TopAndBottom" />
                             <PagerStyle CssClass="pg" HorizontalAlign="Right" VerticalAlign="Middle" BorderStyle="None" 
                       Font-Bold="true" Font-Size="Medium" />
                            <HeaderStyle CssClass="tbl-header" />
                            <RowStyle CssClass="tbl-row" />
                            <AlternatingRowStyle CssClass="tbl-altrow" />
                            <EmptyDataRowStyle />
                            <EmptyDataTemplate>
                                No Record found
                            </EmptyDataTemplate>
                            <EmptyDataRowStyle VerticalAlign="Middle" HorizontalAlign="Center" />
                        </asp:GridView>
                        <br />
                        <br />
                        <asp:Button ID="Button1" runat="server" CssClass="btn btn-primary" Text="Proceed"
                            OnClientClick="return checkSelectedCustomer('Please select customer to send news letter.');" OnClick="btnProceed_Click" />
                        &nbsp;
                    <asp:Button ID="Button2" runat="server" CssClass="btn btn-primary loading" Text="Cancel" OnClick="btnCancel_Click" />
                </div>
            </div>

          </section>
      <div class="row Footercenter">
        <center>All right reserved - www.ei8htpos.com &copy; 2015</center>
    </div>





</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ScriptContent" runat="server">
     <script>
         $(document).ready(function () {
             ShowOrHide(false);
             $('.cwhite input').click(function () {
                 var spanrel = $(this).parent().attr('rel');
                 if (spanrel == 'all') {
                     ShowOrHide(false);
                 }
                 else if (spanrel == 'selected') {
                     ShowOrHide(true);
                 }
             });
         });

         function ShowOrHide(show) {
             if (show) {
                 $('.customers').fadeIn("medium").show();
             }
             else {
                 $('.customers').fadeOut('slow').hide();
             }
         }

         function checkSelectedCustomer(message) {
             var spanrel = $(".cwhite input:checked").parent().attr('rel');
             if (spanrel === undefined || spanrel === null) {
                 ShowFadeMessage(message);
                 closeLoadingPanel();
                 return false;
             }
             else {
                 if (spanrel == 'selected') {
                     if (CheckBoxValidation(message)) {
                         return true;
                     }
                     else {
                         ShowOrHide(true);
                         return false;
                     }
                 }
             }
             return true;
         }
    </script>
</asp:Content>
